<?php 
include 'koneksi.php';

// Ambil semua data rating
$data = [];
$result = $conn->query("SELECT * FROM ratingss");
while ($row = $result->fetch_assoc()) {
    $data[$row['User_id']] = [
        'Interstellar' => $row['Interstellar'],
        'Inception' => $row['Inception'],
        'Titanic' => $row['Titanic'],
        'Avatar' => $row['Avatar'],
        'Matrix' => $row['Matrix']
    ];
}

// Pastikan user U6 tersedia
if (!isset($data['U6'])) {
    die("User U6 tidak ditemukan di data ratings.");
}
$u6 = $data['U6'];

// Fungsi cosine similarity antar dua film
function cosine_similarity($item1, $item2, $data) {
    $dot = 0;
    $norm1 = 0;
    $norm2 = 0;
    foreach ($data as $ratings) {
        if ($ratings[$item1] > 0 && $ratings[$item2] > 0) {
            $a = $ratings[$item1];
            $b = $ratings[$item2];
            $dot += $a * $b;
            $norm1 += $a * $a;
            $norm2 += $b * $b;
        }
    }
    if ($norm1 == 0 || $norm2 == 0) return 0;
    return $dot / (sqrt($norm1) * sqrt($norm2));
}

// Prediksi rating U6 terhadap Titanic
$items = ['Interstellar', 'Inception', 'Avatar', 'Matrix'];
$numerator = 0;
$denominator = 0;

foreach ($items as $item) {
    $sim = cosine_similarity('Titanic', $item, $data);
    $rating = $u6[$item];
    $numerator += $sim * $rating;
    $denominator += abs($sim);
}
$prediksi = ($denominator != 0) ? $numerator / $denominator : 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Rekomendasi Film U6</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        :root {
            --primary: #795548;
            --secondary: #efebe9;
            --accent: #5d4037;
            --bg1: #f3e5ab;
            --bg2: #e1c699;
            --text: #3e2723;
        }

        body {
            margin: 0;
            font-family: 'Inter', sans-serif;
            color: var(--text);
            background: linear-gradient(-45deg, var(--bg1), var(--bg2), #f8ede3, var(--bg1));
            background-size: 400% 400%;
            animation: gradient 12s ease infinite;
        }

        @keyframes gradient {
            0% {background-position: 0% 50%;}
            50% {background-position: 100% 50%;}
            100% {background-position: 0% 50%;}
        }

        .container {
            max-width: 960px;
            margin: 50px auto;
            background-color: #fff8f0;
            padding: 32px;
            border-radius: 20px;
            box-shadow: 0 8px 30px rgba(121, 85, 72, 0.2);
        }

        h1, h2 {
            text-align: center;
            color: var(--primary);
            margin-bottom: 20px;
        }

        .identity {
            display: flex;
            align-items: center;
            gap: 24px;
            margin-bottom: 36px;
        }

        .identity img {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            border: 4px solid var(--primary);
        }

        .identity-info p {
            margin: 4px 0;
            font-size: 19px;
            font-weight: 500;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 24px;
            border-radius: 12px;
            overflow: hidden;
        }

        th, td {
            padding: 14px;
            text-align: center;
        }

        th {
            background-color: var(--primary);
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f5eee6;
        }

        tr:hover {
            background-color: #f0dfcc;
        }

        .highlight {
            margin-top: 30px;
            background-color: var(--secondary);
            padding: 20px;
            border-left: 6px solid var(--accent);
            border-radius: 12px;
            font-size: 15px;
        }

        .btn-toggle {
            display: inline-block;
            margin: 30px auto 0;
            background-color: var(--primary);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 10px;
            cursor: pointer;
            font-weight: 600;
            transition: background 0.3s ease;
        }

        .btn-toggle:hover {
            background-color: var(--accent);
        }

        #rumus {
            display: none;
            margin-top: 20px;
            padding: 16px;
            background-color: #fff3e0;
            border-left: 4px solid var(--primary);
            border-radius: 10px;
            font-size: 14px;
        }

        .rating-badge {
            display: inline-flex;
            font-weight: 600;
            font-size: 14px;
        }

        td.user-name {
            font-weight: bold;
            transition: color 0.3s ease;
        }

        td.user-name:hover {
            color: var(--accent);
            cursor: pointer;
        }

        @media (max-width: 600px) {
            .identity {
                flex-direction: column;
                align-items: flex-start;
            }
            table, th, td {
                font-size: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Sistem Rekomendasi Film</h1>

        <div class="identity">
            <img src="chelsea2.jpg" alt="Foto Mahasiswa">
            <div class="identity-info">
                <p><strong>NIM:</strong> 2302050846</p>
                <p><strong>Nama:</strong> Chelsea Disa</p>
                <p><strong>Prodi:</strong> Sistem Informasi</p>
                <p><strong>Kelas:</strong> SI-A</p>
            </div>
        </div>

        <h2>Data Rating Pengguna</h2>
        <table>
            <thead>
                <tr>
                    <th>User</th>
                    <th>Interstellar</th>
                    <th>Inception</th>
                    <th>Titanic</th>
                    <th>Avatar</th>
                    <th>Matrix</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data as $user => $ratings): ?>
                    <tr>
                        <td class="user-name"><?= $user ?></td>
                        <?php foreach (['Interstellar', 'Inception', 'Titanic', 'Avatar', 'Matrix'] as $film): ?>
                            <?php 
                                $rating = $ratings[$film];
                                $badgeClass = '';
                                if ($rating >= 4) $badgeClass = 'rating-high';
                                elseif ($rating <= 2) $badgeClass = 'rating-low';
                                else $badgeClass = 'rating-medium';
                            ?>
                            <td>
                                <span class="rating-badge <?= $badgeClass ?>">
                                    <i class="rating-badge"></i> <?= $rating ?>
                                </span>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="highlight">
            <?php if ($prediksi == 0): ?>
                <p><strong>Rekomendasi:</strong> Belum cukup data untuk memprediksi rating <strong>Titanic</strong> untuk <strong>U6</strong>.</p>
            <?php else: ?>
                <p><strong>Rekomendasi untuk U6:</strong> Film <strong>Titanic</strong> diprediksi akan mendapatkan rating <strong><?= round($prediksi, 2) ?></strong> berdasarkan kemiripan dengan film lainnya.</p>
            <?php endif; ?>
        </div>

        <button class="btn-toggle" onclick="toggleRumus()">Lihat Rumus Perhitungan</button>

        <div id="rumus">
    <p><strong>Rumus:</strong> <em>Prediksi(U6, Titanic) = (Σ sim(i, Titanic) × rating(U6, i)) / Σ |sim(i, Titanic)|</em></p>
    <ul>
        <li><strong>sim(i, Titanic):</strong> Cosine similarity antara film <code>i</code> dan <code>Titanic</code>.</li>
        <li><strong>i:</strong> Semua film yang telah diberi rating oleh U6 (selain Titanic).</li>
        <li>Digunakan hanya jika minimal 2 user memberi rating pada dua film tersebut.</li>
    </ul>

    <p><strong>Cara kerja perhitungannya:</strong></p>
    <p>Untuk memprediksi rating U6 terhadap film <strong>Titanic</strong>, sistem menghitung tingkat kemiripan (cosine similarity) antara Titanic dengan film lain yang telah dirating oleh U6, yaitu: Interstellar, Inception, Avatar, dan Matrix.</p>

    <p>Kemudian, setiap similarity tersebut dikalikan dengan rating yang diberikan U6 pada film tersebut. Misalnya:</p>
    <ul>
        <li>sim(Titanic, Interstellar) = 0.95 × rating U6 (4) = 3.80</li>
        <li>sim(Titanic, Inception) = 0.97 × rating U6 (3) = 2.91</li>
        <li>sim(Titanic, Avatar) = 0.88 × rating U6 (2) = 1.76</li>
        <li>sim(Titanic, Matrix) = 0.93 × rating U6 (5) = 4.65</li>
    </ul>

    <p><strong>Total pembilang:</strong> 3.80 + 2.91 + 1.76 + 4.65 = <strong>13.12</strong></p>
    <p><strong>Total penyebut:</strong> 0.95 + 0.97 + 0.88 + 0.93 = <strong>3.73</strong></p>
    <p><strong>Hasil akhir:</strong> 13.12 / 3.73 = <strong>3.86</strong></p>

    <p>Jadi, sistem merekomendasikan bahwa <strong>U6 kemungkinan akan memberi rating sebesar 3.86 terhadap film Titanic</strong>.</p>
</div>


    <script>
        function toggleRumus() {
            const el = document.getElementById("rumus");
            el.style.display = (el.style.display === "block") ? "none" : "block";
        }
    </script> 
</body>
</html>
